*                                                                                  ;
 *    Reading in the 1969 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam71.raw' ;
 
 data one;
 
   infile 'F:\PSID\71FAM.DAT'  lrecl=949 missover;
   INPUT
   V1801 1-3              V1802 4-7              V1803 8-9
   V1804 10-12            V1805 13-17            V1806 18
   V1807 19               V1808 20               V1809 21
   V1810 22               V1811 23               V1812 24
   V1813 25               V1814 26               V1815 27
   V1816 28               V1817 29-32            V1818 33
   V1819 34-36            V1820 37               V1821 38-40
   V1822 41               V1823 42-46            V1824 47
   V1825 48-52            V1826 53               V1827 54-57
   V1828 58               V1829 59-62            V1830 63
   V1831 64-67            V1832 68               V1833 69
   V1834 70-73            V1835 74               V1836 75-78
   V1837 79               V1838 80-83            V1839 84-87
   V1840 88               V1841 89-92            V1842 93
   V1843 94-97            V1844 98               V1845 99-102
   V1846 103              V1847 104-106          V1848 107
   V1849 108-111          V1850 112              V1851 113-116
   V1852 117              V1853 118-120          V1854 121
   V1855 122-125          V1856 126              V1857 127-130
   V1858 131              V1859 132-135          V1860 136
   V1861 137-140          V1862 141              V1863 142-145
   V1864 146              V1865 147-150          V1866 151
   V1867 152              V1868 153-154          V1869 155
   V1870 156-160 .2       V1871 161-165          V1872 166-169
   V1873 170              V1874 171-173          V1875 174
   V1876 175-178          V1877 179              V1878 180-183
   V1879 184              V1880 185-188          V1881 189
   V1882 190-193          V1883 194              V1884 195-198
   V1885 199              V1886 200-203          V1887 204
   V1888 205-208          V1889 209              V1890 210
   V1891 211              V1892 212-216          V1893 217
   V1894 218              V1895 219              V1896 220
   V1897 221-225          V1898 226              V1899 227-231
   V1900 232              V1901 233              V1902 234
   V1903 235              V1904 236              V1905 237
   V1906 238-242          V1907 243              V1908 244-248
   V1909 249              V1910 250-254          V1911 255-259
   V1912 260              V1913 261-265          V1914 266-270
   V1915 271-275          V1916 276-280          V1917 281-285
   V1918 286              V1919 287              V1920 288
   V1921 289              V1922 290-294          V1923 295-298
   V1924 299-303          V1925 304              V1926 305-309
   V1927 310-314          V1928 315              V1929 316
   V1930 317              V1931 318-321          V1932 322-325
   V1933 326-329          V1934 330-333          V1935 334-336
   V1936 337              V1937 338-346          V1938 347-348
   V1939 349              V1940 350-352          V1941 353-354
   V1942 355-356          V1943 357              V1944 358-359
   V1945 360              V1946 361-362          V1947 363
   V1948 364              V1949 365              V1950 366
   V1951 367              V1952 368              V1953 369
   V1954 370              V1955 371              V1956 372
   V1957 373              V1958 374-375          V1959 376
   V1960 377              V1961 378              V1962 379
   V1963 380              V1964 381              V1965 382
   V1966 383              V1967 384              V1968 385
   V1969 386              V1970 387              V1971 388
   V1972 389              V1973 390              V1974 391
   V1975 392              V1976 393              V1977 394
   V1978 395              V1979 396              V1980 397
   V1981 398              V1982 399              V1983 400
   V1984 401              V1985 402-403          V1986 404
   V1987 405              V1988 406              V1989 407
   V1990 408              V1991 409              V1992 410
   V1993 411-412          V1994 413              V1995 414-415
   V1996 416              V1997 417-418          V1998 419-420
   V1999 421-422          V2000 423              V2001 424-426
   V2002 427              V2003 428-430          V2004 431
   V2005 432              V2006 433              V2007 434-436
   V2008 437-438          V2009 439-440          V2010 441
   V2011 442              V2012 443              V2013 444
   V2014 445-446          V2015 447              V2016 448
   V2017 449              V2018 450              V2019 451
   V2020 452              V2021 453              V2022 454-456
   V2023 457              V2024 458              V2025 459
   V2026 460              V2027 461-463          V2028 464
   V2029 465              V2030 466              V2031 467
   V2032 468-470          V2033 471              V2034 472
   V2035 473              V2036 474              V2037 475-476
   V2038 477              V2039 478-479          V2040 480-481
   V2041 482-483          V2042 484-485          V2043 486-487
   V2044 488              V2045 489              V2046 490
   V2047 491              V2048 492              V2049 493
   V2050 494-496          V2051 497              V2052 498-500
   V2053 501              V2054 502              V2055 503
   V2056 504              V2057 505              V2058 506
   V2059 507-508          V2060 509-510          V2061 511-512
   V2062 513              V2063 514              V2064 515-517
   V2065 518              V2066 519              V2067 520
   V2068 521              V2069 522-524          V2070 525
   V2071 526              V2072 527              V2073 528
   V2074 529              V2075 530-531          V2076 532-533
   V2077 534-535          V2078 536              V2079 537
   V2080 538              V2081 539              V2082 540
   V2083 541              V2084 542              V2085 543
   V2086 544              V2087 545              V2088 546-547
   V2089 548              V2090 549              V2091 550
   V2092 551              V2093 552              V2094 553
   V2095 554              V2096 555              V2097 556
   V2098 557              V2099 558              V2100 559
   V2101 560              V2102 561              V2103 562
   V2104 563              V2105_1 564            V2105_2 565
   V2106 566              V2107 567              V2108 568
   V2109 569              V2110_1 570            V2110_2 571
   V2111 572              V2112 573              V2113 574
   V2114 575              V2115 576              V2116 577
   V2117 578              V2118 579              V2119 580
   V2120 581              V2121 582              V2122 583
   V2123 584              V2124 585              V2125 586
   V2126 587              V2127 588              V2128 589-590
   V2129 591              V2130 592              V2131 593
   V2132 594-595          V2133 596              V2134 597
   V2135 598              V2136_1 599            V2136_2 600
   V2137 601              V2138 602              V2139 603
   V2140 604              V2141 605              V2142 606
   V2143 607              V2144 608              V2145 609
   V2146 610              V2147 611              V2148 612
   V2149 613              V2150 614              V2151 615
   V2152 616              V2153 617              V2154 618
   V2155 619              V2156 620              V2157 621
   V2158 622              V2159 623              V2160 624
   V2161 625              V2162 626              V2163 627
   V2164 628              V2165 629              V2166 630-631
   V2167 632-634          V2168 635-636          V2169 637-639
   V2170 640              V2171 641              V2172 642
   V2173 643-644          V2174 645-646          V2175 647-648
   V2176 649-650          V2177 651              V2178 652
   V2179 653              V2180 654-655          V2181 656
   V2182 657              V2183 658              V2184 659-660
   V2185 661              V2186 662              V2187 663
   V2188 664              V2189 665-666          V2190 667-669
   V2191 670              V2192 671              V2193 672
   V2194 673              V2195 674              V2196 675
   V2197 676              V2198 677              V2199 678
   V2200 679              V2201 680              V2202 681
   V2203 682              V2204 683              V2205 684
   V2206 685              V2207 686              V2208 687
   V2209 688-690          V2210 691              V2211 692
   V2212 693              V2213 694              V2214 695
   V2215 696              V2216 697              V2217 698
   V2218_1 699            V2218_2 700            V2219 701-704
   V2220 705-708          V2221 709-712          V2222 713-716
   V2223 717              V2224 718-721          V2225 722-725
   V2226 726-730          V2227 731              V2228 732
   V2229 733              V2230 734              V2231 735
   V2232 736              V2233 737              V2234 738
   V2235 739              V2236 740              V2237 741
   V2238 742              V2239 743-747          V2240 748
   V2241 749              V2242 750-753 .2       V2243 754
   V2244 755-757          V2245 758              V2246 759-762
   V2247 763-767          V2248 768              V2249 769-773
   V2250 774-778          V2251 779              V2252 780-783 .2
   V2253 784              V2254 785-787          V2255 788
   V2256 789-792          V2257 793              V2258 794-798
   V2259 799              V2260 800-803 .2       V2261 804
   V2262 805-807          V2263 808              V2264 809-813
   V2265 814              V2266 815-818 .2       V2267 819
   V2268 820-822          V2269 823              V2270 824-826
   V2271 827-830          V2272 831              V2273 832-835 .2
   V2274 836              V2275 837-840          V2276 841
   V2277 842-845          V2278 846              V2279 847-850 .2
   V2280 851              V2281 852-855 .2       V2282 856
   V2283 857              V2284 858              V2285 859
   V2286 860              V2287 861              V2288 862
   V2289 863              V2290 864              V2291 865
   V2292 866-867          V2293 868-869          V2294 870-874
   V2295 875              V2296 876              V2297 877
   V2298 878              V2299 879              V2300 880
   V2301 881-882 .1       V2302 883              V2303 884-885
   V2304 886-889          V2305 890              V2306 891
   V2307 892              V2308 893              V2309 894
   V2310 895              V2311 896              V2312 897
   V2313 898              V2314 899              V2315 900
   V2316 901-904          V2317 905-908          V2318 909
   V2319 910              V2320 911              V2321 912-913
   V2322 914              V2323 915              V2324 916
   V2325 917              V2326 918              V2327 919
   V2328 920              V2329 921              V2330 922
   V2331 923              V2332 924              V2333 925
   V2334 926              V2335 927              V2336 928
   V2337 929              V2338 930              V2339 931-933
   V2340 934-936          V2341 937-939          V2342 940-942
   V2343 943              V2344 944              V2345 945-948
   V2346 949;

* SAS LABEL STATEMENT;

LABEL
   V1801 = "STUDY 768 (WAVE 4)"
   V1802 = "71 ID NO."
   V1803 = "STATE NOW       33:10-11"
   V1804 = "COUNTY NOW      33:12-14"
   V1805 = "ST+CNTY NOW     33:10-14"
   V1806 = "COVERSHEET COLOR   33:16"
   V1807 = "ONCE REFUSED       33:18"
   V1808 = "PHONE INTERVIEW    33:20"
   V1809 = "CHANGE IN FU COMP  33:22"
   V1810 = "# MOVED INTO FU    33:24"
   V1811 = "REL-HEAD:MOVER IN  33:15"
   V1812 = "# MOVED OUT OF FU  33:17"
   V1813 = "REL-HEAD:MOVER OUT 33:19"
   V1814 = "71 FU COMPOSITION  33:21"
   V1815 = "QUALITY OF MATCH   33:23"
   V1816 = "LRGST PLAC/SMSA PSU33:25"
   V1817 = "VALUE OF CARS   33:26-29"
   V1818 = "ACCURACY CAR VALUE 33:30"
   V1819 = "SAVE CAR REPAIR 33:31-33"
   V1820 = "ACC OF SAVED CAR   33:34"
   V1821 = "HRS CAR REPAIR  33:35-37"
   V1822 = "ACC HRS CAR REPAIR 33:38"
   V1823 = "HOUSE VALUE     33:39-43"
   V1824 = "ACC HOUSE VALUE    33:44"
   V1825 = "REM MORT PRINC  33:45-49"
   V1826 = "ACC REM MORT PRINC 33:50"
   V1827 = "ANNUAL MORT PAY 33:51-54"
   V1828 = "ACC MORT PAY       33:55"
   V1829 = "ANNUAL RENT     33:56-59"
   V1830 = "ACC ANNUAL RENT    33:60"
   V1831 = "ANNUAL RENT VAL 33:61-64"
   V1832 = "ACC ANNUAL RENT VAL33:65"
   V1833 = "CODE:WK FOR HOUSE  33:66"
   V1834 = "ANNUAL UTILITIES33:67-70"
   V1835 = "ACC UTILITIES      33:71"
   V1836 = "$  SAVED ON A& R  33:72-75"
   V1837 = "ACC $  SAVED A& R    33:76"
   V1838 = "HOME PROD HRS   33:77-80"
   V1839 = "HRS HEAD WORKED 34:10-13"
   V1840 = "ACC HRS HD WKD     34:14"
   V1841 = "HRS HEAD ILL    34:15-18"
   V1842 = "ACC HRS HD ILL     34:19"
   V1843 = "HRS HEAD UNEMP  34:20-23"
   V1844 = "ACC HRS HEAD UNEMP 34:24"
   V1845 = "$  HEAD TRVL WK  34:25-28"
   V1846 = "ACC $  HEAD TRVL WK 34:29"
   V1847 = "HRS HEAD TRVL WK34:30-32"
   V1848 = "ACC HRS HEAD TR WK 34:33"
   V1849 = "HRS WIFE WORKED 34:34-37"
   V1850 = "ACC HRS WIFE WK    34:38"
   V1851 = "$  WIFE TRVL WK  34:39-42"
   V1852 = "ACC WIFE TRVL WK   34:43"
   V1853 = "HRS WF TRVL WK  34:44-46"
   V1854 = "ACC HRS WF TRVL WK 34:47"
   V1855 = "HRS HSWRK 1ST   34:48-51"
   V1856 = "ACC HRS HSWRK 1ST  34:52"
   V1857 = "HRS HSWRK HUSBND34:53-56"
   V1858 = "ACC HSWRK HUSBND   34:57"
   V1859 = "HRS HSWRK OTHER 34:58-61"
   V1860 = "ACC HRS HSWRK OTHR 34:62"
   V1861 = "HRS HSWRK NONFU 34:63-66"
   V1862 = "ACC HRS HSWRK NONFU34:67"
   V1863 = "$  HSWRK NONFU   34:68-71"
   V1864 = "ACC $  HSWRK NONFU  34:72"
   V1865 = "COST CHILD CARE 34:73-76"
   V1866 = "ACC COST CHILD CARE34:77"
   V1867 = "# MAJOR ADULTS     34:78"
   V1868 = "# IN FU         35:10-11"
   V1869 = "# REQUIRED ROOMS   35:12"
   V1870 = "FU WKLY FOOD STD35:13-17"
   V1871 = "ANNUAL NEED STD 23:18-22"
   V1872 = "$  ANNUAL ALCOHOL35:23-26"
   V1873 = "ACC $  ANN ALCOHOL  35:27"
   V1874 = "$  ANNUAL CIGS   35:28-30"
   V1875 = "ACC $  ANN CIGARETTE35:31"
   V1876 = "$  FOOD USED HOME35:32-35"
   V1877 = "ACC $  FOOD HOME    35:36"
   V1878 = "$  MEALS WRK/SCH 35:37-40"
   V1879 = "ACC $  MEALS W/S    35:41"
   V1880 = "$  SAVD GROW FOOD35:42-45"
   V1881 = "ACC $  SAVD GROW FD 35:46"
   V1882 = "$  SAVD WRK/SCH  35:47-50"
   V1883 = "ACC $  SAVD WRK/SCH 35:51"
   V1884 = "$  SAVD FOOD STMP35:52-55"
   V1885 = "ACC $  SAVD FD STMP 35:56"
   V1886 = "$  EATING OUT    35:57-60"
   V1887 = "ACC $  EATING OUT   35:61"
   V1888 = "$  SAVD OTHER FD 35:62-65"
   V1889 = "ACC $  SAVD OTHER FD35:66"
   V1890 = "BKT LABOR FARM Y   36:10"
   V1891 = "BKT LABOR BUS.Y    36:11"
   V1892 = "HEAD WAGES      36:12-16"
   V1893 = "ACC HEAD WAGES     36:17"
   V1894 = "BKT BONUS,OVERTIME 36:18"
   V1895 = "BKT PROF.PRACT,TRD 36:19"
   V1896 = "BKT LABOR ROOMER Y 36:20"
   V1897 = "LABOR INC HEAD  36:21-25"
   V1898 = "ACC LABOR Y HEAD   36:26"
   V1899 = "LABOR INC WIFE  36:27-31"
   V1900 = "ACC LABOR Y WIFE   36:32"
   V1901 = "BKT ASSET FARM Y   36:33"
   V1902 = "BKT ASSET BUS. Y   36:34"
   V1903 = "BKT ASSET ROOMER Y 36:35"
   V1904 = "BKT RENT,DIV,INT   36:36"
   V1905 = "BKT WIFE ASSET Y   36:37"
   V1906 = "H+W TAXABLE INC 36:38-42"
   V1907 = "ACC H& W TAXBL INC  36:43"
   V1908 = "$  CNTRB OUT FU  36:44-48"
   V1909 = "# DEPENDENTS H& W   36:49"
   V1910 = "TAXES OF H& W    36:50-54"
   V1911 = "ADC, AFDC H& W   37:10-14"
   V1912 = "ACC ADC H& W        37:15"
   V1913 = "OTHER WELFARE   37:16-20"
   V1914 = "SOCIAL SECURITY 37:21-25"
   V1915 = "OTHER RETIREMENT37:26-30"
   V1916 = "UNEMP,WRK.COMP  37:31-35"
   V1917 = "ALIMONY,CHLD SPT37:36-40"
   V1918 = "BKT HELP FROM REL. 37:41"
   V1919 = "BKT ANYTHING ELSE  37:42"
   V1920 = "BKT WIFE TRANSFERS 37:43"
   V1921 = "ACC MISC TRANSFERS 37:44"
   V1922 = "TRANSFER Y H& W  37:45-49"
   V1923 = "HOURS WRK OTHERS37:50-53"
   V1924 = "TAXBL INC OTHERS37:54-58"
   V1925 = "ACC TAXBL Y OTHERS 37:59"
   V1926 = "OTHERS TAXES    37:60-64"
   V1927 = "OTHERS TRANSFER 37:65-69"
   V1928 = "ACC OTHERS TRANS Y 37:70"
   V1929 = "# OTHER Y RECEIVERS37:71"
   V1930 = "# OTHER W LABOR INC37:72"
   V1931 = "LABOR UNION DUES37:73-76"
   V1932 = "1968 INTERVIEW# 38:10-13"
   V1933 = "1969 INTERVIEW# 38:14-17"
   V1934 = "1970 INTERVIEW# 38:18-21"
   V1935 = "ORIGINAL PSU #  38:22-24"
   V1936 = "PSU-HUNDREDS DIGIT 38:22"
   V1937 = "IWERS SOC SEC # 38:25-33"
   V1938 = "IWERS INT #     38:34-35"
   V1939 = "DATE OF IW         38:36"
   V1940 = "LENGTH OF IW    38:37-39"
   V1941 = "# IN FU         38:40-41"
   V1942 = "AGE OF HEAD     38:42-43"
   V1943 = "SEX OF HEAD        38:44"
   V1944 = "AGE OF WIFE     38:45-46"
   V1945 = "# CHILDREN IN FU   38:47"
   V1946 = "AGE YNGST CHILD 38:48-49"
   V1947 = "ANY CHILD UNDER 25 38:50"
   V1948 = "# CHLDRN IN SCHOOL 38:51"
   V1949 = "EDUC EXPT CHILDREN 38:52"
   V1950 = "LAST PTA MTG ATTND 38:53"
   V1951 = "ANY CHILD STOP SCH 38:54"
   V1952 = "PUBLIC TRANSP AVAIL38:55"
   V1953 = "PUB TRANSP GOOD    38:56"
   V1954 = "OWN A CAR OR TRUCK 38:57"
   V1955 = "DIFFIC FROM NO CAR 38:58"
   V1956 = "WHAT DIFFIC NO CAR 38:59"
   V1957 = "NR CARS OWNED      38:60"
   V1958 = "YR OF NEWEST CAR38:61-62"
   V1959 = "CONDIT NEWEST CAR  38:63"
   V1960 = "ALL CARS INSURED?  38:64"
   V1961 = "CAR HAVE SEAT BELTS38:65"
   V1962 = "SEAT BELTS FASTND  38:66"
   V1963 = "DID OWN REPAIR     38:67"
   V1964 = "KIND OF CAR REPAIR 38:68"
   V1965 = "DUMMY VARIABLE #1  38:69"
   V1966 = "ACTUAL # ROOMS     39:10"
   V1967 = "OWN OR RENT?       39:11"
   V1968 = "MORTGAGE?          39:12"
   V1969 = "PYMTS INCLUD TAXES?39:13"
   V1970 = "PYMTS INC INS PREM?39:14"
   V1971 = "SECOND MORTGAGE?   39:15"
   V1972 = "WHY FREE HOUSING?  39:16"
   V1973 = "WORK DONE ON HOUSE 39:17"
   V1974 = "WHAT A& R DONE?     39:18"
   V1975 = "A& R DONE SELF      39:19"
   V1976 = "WHAT A& R DONE SELF 39:20"
   V1977 = "NR NEIGHBORS KNOWN 39:21"
   V1978 = "RELATIVES NEAR     39:22"
   V1979 = "MOVED SINCE SPRING 39:23"
   V1980 = "WHY MOVED?         39:24"
   V1981 = "MIGHT MOVE         39:25"
   V1982 = "WHY MIGHT MOVE     39:26"
   V1983 = "EMPLOYMENT STATUS  39:27"
   V1984 = "OCCUPATION-HEAD(E) 39:28"
   V1985 = "INDUS-HEAD OCC  39:29-30"
   V1986 = "SELF EMPLOYED HEAD 39:31"
   V1987 = "HOW LONG HAD JOB   39:32"
   V1988 = "HAPPENED PREV JOB  39:33"
   V1989 = "JOB PAY MORE NOW   39:34"
   V1990 = "PRESENT JOB BETTER 39:35"
   V1991 = "WHY JOB BETTER     39:36"
   V1992 = "TOOK VACATION 70(E)39:37"
   V1993 = "WKS VAC 70(E)   39:38-39"
   V1994 = "MISS WORK SICK(E)  39:40"
   V1995 = "WKS SICK (E)    39:41-42"
   V1996 = "UNEMPLOYED? (E)    39:43"
   V1997 = "WKS UNEMPLYD (E)39:44-45"
   V1998 = "WKS WORK HEAD(E)39:46-47"
   V1999 = "HRS/WK WRK HD(E)39:48-49"
   V2000 = "EXTRA HRS PAY (E)  39:50"
   V2001 = "OTIME HRLY WAGE 39:51-53"
   V2002 = "WTR REG WAGE (E)   39:54"
   V2003 = "REG HRLY WAGE(E)39:55-57"
   V2004 = "EXTRA JOBS? (E)    39:58"
   V2005 = "OCCUP EXTRA JOB(E) 39:59"
   V2006 = "MORE THAN 2 JOBS(E)39:60"
   V2007 = "PAY/HR XTRA WRK 39:61-63"
   V2008 = "WEEKS EXTRA JOB 39:64-65"
   V2009 = "HRS/WK XTRA JOB 39:66-67"
   V2010 = "MORE WRK AVAILABLE 39:68"
   V2011 = "WANTED MORE WORK   39:69"
   V2012 = "COULD WORK LESS    39:70"
   V2013 = "PREFRD LESS WORK   39:71"
   V2014 = "MILES TO WORK   39:72-73"
   V2015 = "DRIVE TO WORK OR?  39:74"
   V2016 = "LATE GETTNG TO WORK40:11"
   V2017 = "HOW OFTEN LATE     40:12"
   V2018 = "SKIP WORK NOT SICK 40:13"
   V2019 = "HOW OFTN SKIP WORK 40:14"
   V2020 = "MAY GET NEW JOB(E) 40:15"
   V2021 = "KIND OF NEW JOB(E) 40:16"
   V2022 = "POSSIBLE WAGE(E)40:17-19"
   V2023 = "TRNING NEW JOB (E) 40:20"
   V2024 = "DOING ABT NEW JOB? 40:21"
   V2025 = "WHAT DO-NEW JOB    40:22"
   V2026 = "WILLING TO MOVE JOB40:23"
   V2027 = "PAY/HR REQD MOVE40:24-26"
   V2028 = "WHY WONT MOVE JOB  40:27"
   V2029 = "CHOOSES WAY WORKS  40:28"
   V2030 = "LIKE MORE CHOICE   40:29"
   V2031 = "OCCUP-HEAD(U)      40:30"
   V2032 = "PAY/HR SOUGHT(U)40:31-33"
   V2033 = "TRAINING REQD (U)  40:34"
   V2034 = "HOW FINDING JOB(U) 40:35"
   V2035 = "# PLACES LOOKED(U) 40:36"
   V2036 = "OCCUP-PREV JOB (U) 40:37"
   V2037 = "IND PREV JOB (U)40:38-39"
   V2038 = "HAPPEND PREV JOB(U)40:40"
   V2039 = "WKS WKD-70 (U)  40:41-42"
   V2040 = "HRS/WK WRK-70   40:43-44"
   V2041 = "WKS SICK-70 (U) 40:45-46"
   V2042 = "WKS UNEMPLYD (U)40:47-48"
   V2043 = "MILES TO WORK(U)40:49-50"
   V2044 = "DRIVE TO WRK OR?(U)40:51"
   V2045 = "LATE TO WORK (U)   40:52"
   V2046 = "HOW OFTEN LATE(U)  40:53"
   V2047 = "SKP WRK-NOT SICK(U)40:54"
   V2048 = "HOW OFTN SKIP WK(U)40:55"
   V2049 = "JOBS NOT WRTH IT(U)40:56"
   V2050 = "PAY/HR REJECT(U)40:57-59"
   V2051 = "WILLNG MOVE JOB(U) 40:60"
   V2052 = "PAY/HR RQD-MV(U)40:61-63"
   V2053 = "WHY NOT MOVE JOB(U)40:64"
   V2054 = "CHOOSES WAY WRKS(U)40:65"
   V2055 = "LIKE MORE CHOICE(U)40:66"
   V2056 = "WTR WKD-70 (R)     41:11"
   V2057 = "THINKING ABT WRK(R)41:12"
   V2058 = "OCCUPATION-HEAD(R) 41:13"
   V2059 = "INDUS-HDS OCC(R)41:14-15"
   V2060 = "WEEKS WRKD-HD(R)41:16-17"
   V2061 = "HRS/WK WKD HD(R)41:18-19"
   V2062 = "NEW JOB NEXT YR?(R)41:20"
   V2063 = "KIND OF NEW JOB (R)41:21"
   V2064 = "POSSIBLE WAGE(R)41:22-24"
   V2065 = "TRNING NEW JOB?(R) 41:25"
   V2066 = "DOING ABT NU JOB(R)41:26"
   V2067 = "# PLACES APPLIED(R)41:27"
   V2068 = "JOBS NOT WRTH IT(R)41:28"
   V2069 = "PAY/HR REJECT(R)41:29-31"
   V2070 = "THINKNG WRK FUT(R) 41:32"
   V2071 = "WRK DEPENDS ON(R)  41:33"
   V2072 = "MARITAL STATUS     41:34"
   V2073 = "DID WIFE WORK      41:35"
   V2074 = "OCCUPATION-WIFE    41:36"
   V2075 = "INDUS WIFES OCC 41:37-38"
   V2076 = "WEEKS WIFE WRKD 41:39-40"
   V2077 = "HRS/WK WIFE WKD 41:41-42"
   V2078 = "WIFE-MORE WRK AVAIL41:43"
   V2079 = "WIFE-WANT MORE WRK?41:44"
   V2080 = "WIFE ABLE FIND JOB?41:45"
   V2081 = "WIFE WRK IN FUTURE 41:46"
   V2082 = "WHY W WIL/WONT WK1 41:47"
   V2083 = "WHY W WIL/WONT WK2 41:48"
   V2084 = "EXPECT CHILDREN?   41:50"
   V2085 = "LIMIT # CHILDREN?  41:51"
   V2086 = "WHEN EXPECT CHILD  41:52"
   V2087 = "WHO DOES HOUSEWORK?41:53"
   V2088 = "HRS/WK 1ST HSWRK41:54-55"
   V2089 = "OTHERS DO HOUSEWORK41:56"
   V2090 = "HELP FROM OUTSIDE? 41:57"
   V2091 = "PAY FOR HELP?      41:58"
   V2092 = "HOW OFTN EAT TGTHR 41:59"
   V2093 = "TOT FARM RECEIPTS  41:61"
   V2094 = "OWN A BUSINESS?    41:62"
   V2095 = "BUS INCORPORATED   41:63"
   V2096 = "INSURANCE,INHERIT  41:64"
   V2097 = "AMT SETTLEMENT BKT 41:65"
   V2098 = "70 Y HIGHER OR 69  41:66"
   V2099 = "WHY INCOME DIFFRNT 41:67"
   V2100 = "UNUSUAL EXPENSES   41:68"
   V2101 = "WHY EXPENSES UNUSL 41:69"
   V2102 = "70 BETTER, OR 69?  41:70"
   V2103 = "WHY 70/69 BTR 1ST  41:71"
   V2104 = "WHY 70/69 BTR 2ND  41:72"
   V2105_1 = "2WAYS 70/69 BTR 41:71-72 RESP 1"
   V2105_2 = "2WAYS 70/69 BTR 41:71-72 RESP 2"
   V2106 = "LOT OR LITTLE BTR? 41:73"
   V2107 = "NXT FEW YRS OUTLOOK41:74"
   V2108 = "1ST REASON OUTLOOK 41:75"
   V2109 = "2ND REASON OUTLOOK 41:76"
   V2110_1 = "2 REASONS OUTLK 41:75-76 RESP 1"
   V2110_2 = "2 REASONS OUTLK 41:75-76 RESP 2"
   V2111 = "ANY OUTSIDE DEPS?  41:77"
   V2112 = "# OUTSIDE DEPENDTS 41:78"
   V2113 = "# DEP >HALF SUPPORT41:79"
   V2114 = "WOULD HELP RELATIVE41:80"
   V2115 = "ANY SAVINGS?       42:10"
   V2116 = "2 MONTHS Y SAVED   42:11"
   V2117 = "2 MO Y SAVD IN 5YRS42:12"
   V2118 = "MEDICAL INSURANCE  42:13"
   V2119 = "ENTIRE FAMLY INSURD42:14"
   V2120 = "FREE MEDICAL CARE? 42:15"
   V2121 = "DISAB LIM KIND WRK 42:16"
   V2122 = "DISAB LIMIT AMT WRK42:17"
   V2123 = "HEALTH LIMIT HSWRK 42:18"
   V2124 = "HOW LONG LIMITED   42:19"
   V2125 = "HEALTH IMPROVING?  42:20"
   V2126 = "OTHERS DISABLED?   42:21"
   V2127 = "WHO ELSE DISABLED? 42:22"
   V2128 = "AGE OF DISABLED 42:23-24"
   V2129 = "WHY OTHER DISABLED 42:25"
   V2130 = "OTHER EXTRA CARE   42:26"
   V2131 = "WHO REQ EXTRA CARE 42:27"
   V2132 = "AGE REQ EXTR CR 42:28-29"
   V2133 = "WHY REQ EXTRA CARE 42:30"
   V2134 = "WHAT DO SPARE TIME 42:31"
   V2135 = "2ND USE SPARE TIME 42:32"
   V2136_1 = "2 USES SPARE TIM42:31-32 RESP 1"
   V2136_2 = "2 USES SPARE TIM42:31-32 RESP 2"
   V2137 = "# THINGS DONE SP-T 42:33"
   V2138 = "COURSES OR LESSONS 42:34"
   V2139 = "WHAT COURSES?      42:35"
   V2140 = "HRS OF TELEVISION  42:36"
   V2141 = "HOW OFTN NEWSPAPER 42:37"
   V2142 = "HOW OFTEN CHURCH   42:38"
   V2143 = "HOW OFTEN CLUBS    42:39"
   V2144 = "HOW OFTEN BAR& TAVRN42:40"
   V2145 = "UNION MEMBER       42:41"
   V2146 = "PLANS TO MAKE DIFF 42:42"
   V2147 = "WHAT PLANS FOR FUT 42:43"
   V2148 = "SURE LIFE WORK OUT 42:44"
   V2149 = "PLAN OR LIVE DAY-DY42:45"
   V2150 = "CARRY OUT PLANS OR 42:46"
   V2151 = "FINSH THINGS OR NOT42:47"
   V2152 = "LIKE DIFF-CHALLENG 42:48"
   V2153 = "RATHR SPEND OR SAVE42:49"
   V2154 = "PREFER CHANCE RAISE42:50"
   V2155 = "SATISFIED WITH SELF42:51"
   V2156 = "HAVE LIMITATIONS   42:52"
   V2157 = "GET ANGRY EASILY   42:53"
   V2158 = "MATTER OTHRS THINK 42:54"
   V2159 = "TRUST MOST OTHERS  42:55"
   V2160 = "FIGR WAYS MOR MONEY42:56"
   V2161 = "THINK ABOUT FUTURE 42:57"
   V2162 = "AV MAN GETTNG BETTR42:58"
   V2163 = "LOT GOOD DONT DSRV 42:59"
   V2164 = "IDEAL # CHILDREN   42:60"
   V2165 = "SAME HEAD?         43:10"
   V2166 = "ST DAD GREW UP  43:11-12"
   V2167 = "CNTY DAD GREW UP43:13-15"
   V2168 = "ST MOM GREW UP  43:16-17"
   V2169 = "CNTY MOM GREW UP43:18-20"
   V2170 = "FATHERS OCCUPATION 43:21"
   V2171 = "HEADS FIRST JOB    43:22"
   V2172 = "HEAD IN SAME OCCUP?43:23"
   V2173 = "AGE OLDST CHILD 43:24-25"
   V2174 = "AGE 2ND OLDEST  43:26-27"
   V2175 = "AGE 3RD OLDEST  43:28-29"
   V2176 = "# CHILDREN HEAD 43:30-31"
   V2177 = "# CHILD HEAD BY 25 43:32"
   V2178 = "# SIBLINGS HEAD    43:33"
   V2179 = "HD ANY LIVNG BRTHR 43:34"
   V2180 = "AGE OLDEST BRTHR43:35-36"
   V2181 = "ED OLDST LIVNG BRTH43:37"
   V2182 = "OLDST BRTH WELLOFF 43:38"
   V2183 = "HD ANY LIVING SISTR43:39"
   V2184 = "AGE OLDEST SISTR43:40-41"
   V2185 = "ED OLDST LIVNG SIST43:42"
   V2186 = "OLDST SIST WELLOFF 43:43"
   V2187 = "RELIGION           43:44"
   V2188 = "HEAD GREW UP FARM  43:45"
   V2189 = "STATE HD GREW UP43:46-47"
   V2190 = "CNTY HD GREW UP 43:48-50"
   V2191 = "# REGIONS LIVED IN 43:51"
   V2192 = "# STATES HD LVD IN 43:52"
   V2193 = "EVER MOVED FOR JOB 43:53"
   V2194 = "EVER REFUSED MOVE  43:54"
   V2195 = "HEADS PARENTS POOR 43:55"
   V2196 = "HDS FATHERS EDUC   43:56"
   V2197 = "EDUCATION OF HEAD  43:57"
   V2198 = "OTHR TRAINING HEAD 43:58"
   V2199 = "HEAD A VETERAN     43:59"
   V2200 = "WHO PRESENT?       43:60"
   V2201 = "WHO RESPONDENT(REL)43:61"
   V2202 = "RACE               43:62"
   V2203 = "NUMBER OF CALLS    43:63"
   V2204 = "HOW CLEAN DU       43:64"
   V2205 = "READING MTL VISIBLE43:65"
   V2206 = "LANGUAGE PROBLEMS  43:66"
   V2207 = "HEAD DISFIGURED    43:67"
   V2208 = "IN CITY OF 5000+   43:68"
   V2209 = "SMSA CODE"
   V2210 = "DIST TO CENTR SMSA 43:72"
   V2211 = "TYPE OF STRUCTURE  43:73"
   V2212 = "NEIGHBORHOOD-LOWST 43:74"
   V2213 = "NEIGHBORHOOD-HGHST 43:75"
   V2214 = "DU IN PUBL HOUSING 43:76"
   V2215 = "INSIDE TOILET      43:77"
   V2216 = "RUNNING WATER      43:78"
   V2217 = "DU NEED EXTEN REPR 43:79"
   V2218_1 = "2REA W WL/WNT WK41:47-48 RESP 1"
   V2218_2 = "2REA W WL/WNT WK41:47-48 RESP 2"
   V2219 = "HOME PROD HRS(REV) 1V419"
   V2220 = "TOTAL NONLEISR HRS 1V420"
   V2221 = "YRLY PROP TAXES 1V421"
   V2222 = "IMPUTED RENT  1V422"
   V2223 = "HOUSE VALUE BKT 1V423"
   V2224 = "LEISURE NET TRAVEL 1V424"
   V2225 = "LEISURE COMP 68 1V425"
   V2226 = "TOT FU MON INC 1V426"
   V2227 = "BKT TOT FU MON INC 1V427"
   V2228 = "BKT LABOR INC HEAD 1V428"
   V2229 = "BKT LABOR INC WIFE 1V429"
   V2230 = "BKT H+W TAXABLE Y 1V430"
   V2231 = "BKT OTHERS TAXBL Y 1V431"
   V2232 = "BKT ADC 1V432"
   V2233 = "BKT OTHER WELFARE 1V433"
   V2234 = "BKT SOCIAL SEC 1V434"
   V2235 = "BKT OTHER RETIREMT 1V435"
   V2236 = "BKT UNEMP WRK COMP 1V436"
   V2237 = "BKT ALMNY CHLD SUP 1V437"
   V2238 = "BKT TOT TRNSFRS H+W1V438"
   V2239 = "MISC TRANSFERS 1V439"
   V2240 = "BKT MISC TRANSFERS 1V440"
   V2241 = "BKT OTHRS TRNSFR Y 1V441"
   V2242 = "MONEY Y/NEEDS 1V442"
   V2243 = "BKT MONEY Y/NEEDS 1V443"
   V2244 = "W-O MONEY 1V444"
   V2245 = "BKT W-O MONEY 1V445"
   V2246 = "FRE HELP FRM OTHRS 1V446"
   V2247 = "TOTAL REAL Y 1V447"
   V2248 = "BKT TOTAL REAL Y 1V448"
   V2249 = "TOTAL COST OF INC 1V449"
   V2250 = "REAL NET Y 1V450"
   V2251 = "BKT REAL NET Y 1V451"
   V2252 = "REAL NET Y/NEEDS 1V452"
   V2253 = "BKT RL NET Y/NEEDS 1V453"
   V2254 = "W-O NET REAL 1V454"
   V2255 = "BKT W-O NET REAL 1V455"
   V2256 = "COST OF HOUSING 1V456"
   V2257 = "BKT COST OF HOUSNG 1V457"
   V2258 = "REAL NET (2)Y 1V458"
   V2259 = "BKT REAL NET (2)Y 1V459"
   V2260 = "NET(2)Y/NEEDS 1V460"
   V2261 = "BKT NET (2)Y/NEEDS 1V461"
   V2262 = "W-O NET (2)Y 1V462"
   V2263 = "BKT W-O NET (2)Y 1V463"
   V2264 = "NET Y-HOUSING 1V464"
   V2265 = "BKT NET Y-HOUSING 1V465"
   V2266 = "NET Y-HSNG/FD ND 1V466"
   V2267 = "BKT Y-HSNG/FD ND 1V467"
   V2268 = "W-O NET Y-HSNG 1V468"
   V2269 = "BKT W-O NET Y-HSNG 1V469"
   V2270 = "W-O NET (2) Y-HSNG 1V470"
   V2271 = "TOTAL FOOD CONS 1V471"
   V2272 = "BKT FOOD CONSMPTN 1V472"
   V2273 = "FOOD CONS/FD ND 1V473"
   V2274 = "BKT FOOD/FD ND 1V474"
   V2275 = "TOTAL FAMILY WORK 1V475"
   V2276 = "BKT TOT FAM WORK 1V476"
   V2277 = "FAM WORK INCL TRAV 1V477"
   V2278 = "BKT WORK INCL TRAV 1V478"
   V2279 = "HEADS AVG HRLY ERN 1V479"
   V2280 = "BKT HD AVG HR EARN 1V480"
   V2281 = "WIFE AV HRLY EARN 1V481"
   V2282 = "BKT WF AV HRLY ERN 1V482"
   V2283 = "RESERVE FUNDS 1V483"
   V2284 = "CURRENT REGION 1V484"
   V2285 = "REGN HD GREW UP 1V485"
   V2286 = "REGN DAD GREW UP 1V486"
   V2287 = "REGN MOM GREW UP 1V487"
   V2288 = "GEOGRAPHIC MOBILITY 1V48"
   V2289 = "ACCURACY MONEY INC 1V489"
   V2290 = "ACCURACY HOURS 1V490"
   V2291 = "ACCURACY REAL INC 1V491"
   V2292 = "#MINOR ASSIGNMTS 1V492"
   V2293 = "#MAJOR ASSIGNMTS 1V493"
   V2294 = "VALUE PER ROOM 1V494"
   V2295 = "BKT VALUE PER ROOM 1V495"
   V2296 = "BKT CAR VALUE 1V496"
   V2297 = "BKT OV-TIM HR WAGE 1V497"
   V2298 = "BKT REG HRLY WAGE 1V498"
   V2299 = "BKT PAY 2ND JOB 1V499"
   V2300 = "ACTUAL-REQD ROOMS 1V500"
   V2301 = "PERSONS PER ROOM 1V501"
   V2302 = "BKT PERSONS/ROOM 1V502"
   V2303 = "NUMBER OF ADULTS 1V503"
   V2304 = "HOUSEWORK H+W 1V504"
   V2305 = "HOUSING NBHD QUAL 1V505"
   V2306 = "EFFICACY &  PLANNING 1V50"
   V2307 = "TRUST OR HOSTILITY 1V507"
   V2308 = "SCRAMBLE FOR WORK 1V508"
   V2309 = "ASPIRATION AMBITIN 1V509"
   V2310 = "REAL EARNING ACTS 1V510"
   V2311 = "ECONOMIZING 1V511"
   V2312 = "RISK AVOIDANCE 1V512"
   V2313 = "HORIZON PROXIES 1V513"
   V2314 = "CONNECTEDNESS 1V514"
   V2315 = "MONEY EARNING ACTS 1V515"
   V2316 = "NON-LEISURE COMP 1V516"
   V2317 = "ANNUAL FOOD STD 1V517"
   V2318 = "ONE DIGIT FAM SIZE 1V518"
   V2319 = "BKT AGE OF HEAD 1V519"
   V2320 = "BKT AGE OF WIFE 1V520"
   V2321 = "WEIGHT             1V521"
   V2322 = "DEC MONEY          1V522"
   V2323 = "DEC MONEY/NEEDS    1V523"
   V2324 = "DEC W-O MONEY      1V524"
   V2325 = "DEC REAL NET       1V525"
   V2326 = "DEC REAL NET/NEEDS 1V526"
   V2327 = "DEC W-O REAL NET   1V527"
   V2328 = "DEC REAL NET-HSNG  1V528"
   V2329 = "DEC RL NET HSG/ND  1V529"
   V2330 = "DEC W-O RL NET HSG 1V530"
   V2331 = "UNSKIL MALE LBR 71 1V531"
   V2332 = "UNSKL FEMAL LBR 71 1V532"
   V2333 = "COMPAR W-NW MKT 71 1V533"
   V2334 = "TYPCL WAGE MALE 71 1V534"
   V2335 = "DIF BET M& F WG RTS 1V535"
   V2336 = "UNEMPL RATE 71     1V536"
   V2337 = "OAA/RECIPIENT 70ST 1V537"
   V2338 = "AFDC/RECIP 70 ST   1V538"
   V2339 = "TOT BDG INDX 70SMSA1V539"
   V2340 = "FD BUD INDX 70SMSA 1V540"
   V2341 = "HSN BUD IND 70SMSA 1V541"
   V2342 = "TRNS BUD IND 70SMSA1V542"
   V2343 = "PUB WELFARE-70CNTY 1V543"
   V2344 = "PUB WELFARE 68CNTY 1V544"
   V2345 = "HOUSEHOLD ID # 71"
   V2346 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V1939 GE 9 THEN V1939=.;
IF V1940 GE 999 THEN V1940=.;
IF V1947 GE 9 THEN V1947=.;
IF V1948 GE 9 THEN V1948=.;
IF V1949 GE 9 THEN V1949=.;
IF V1950 GE 9 THEN V1950=.;
IF V1951 GE 9 THEN V1951=.;
IF V1952 GE 9 THEN V1952=.;
IF V1953 GE 9 THEN V1953=.;
IF V1954 GE 9 THEN V1954=.;
IF V1955 GE 9 THEN V1955=.;
IF V1956 GE 9 THEN V1956=.;
IF V1957 GE 9 THEN V1957=.;
IF V1958 GE 99 THEN V1958=.;
IF V1959 GE 9 THEN V1959=.;
IF V1960 GE 9 THEN V1960=.;
IF V1961 GE 9 THEN V1961=.;
IF V1962 GE 9 THEN V1962=.;
IF V1963 GE 9 THEN V1963=.;
IF V1964 GE 9 THEN V1964=.;
IF V1965 GE 0 THEN V1965=.;
IF V1966 GE 9 THEN V1966=.;
IF V1968 GE 9 THEN V1968=.;
IF V1969 GE 9 THEN V1969=.;
IF V1970 GE 9 THEN V1970=.;
IF V1971 GE 9 THEN V1971=.;
IF V1972 GE 9 THEN V1972=.;
IF V1973 GE 9 THEN V1973=.;
IF V1974 GE 9 THEN V1974=.;
IF V1975 GE 9 THEN V1975=.;
IF V1976 GE 9 THEN V1976=.;
IF V1977 GE 9 THEN V1977=.;
IF V1978 GE 9 THEN V1978=.;
IF V1979 GE 9 THEN V1979=.;
IF V1980 GE 9 THEN V1980=.;
IF V1981 GE 9 THEN V1981=.;
IF V1982 GE 9 THEN V1982=.;
IF V1986 GE 9 THEN V1986=.;
IF V1987 GE 9 THEN V1987=.;
IF V1988 GE 9 THEN V1988=.;
IF V1989 GE 9 THEN V1989=.;
IF V1990 GE 9 THEN V1990=.;
IF V1991 GE 9 THEN V1991=.;
IF V1992 GE 9 THEN V1992=.;
IF V1993 GE 99 THEN V1993=.;
IF V1994 GE 9 THEN V1994=.;
IF V1995 GE 99 THEN V1995=.;
IF V1996 GE 9 THEN V1996=.;
IF V1997 GE 99 THEN V1997=.;
IF V1998 GE 99 THEN V1998=.;
IF V1999 GE 99 THEN V1999=.;
IF V2000 GE 9 THEN V2000=.;
IF V2001 GE 999 THEN V2001=.;
IF V2002 GE 9 THEN V2002=.;
IF V2003 GE 999 THEN V2003=.;
IF V2004 GE 9 THEN V2004=.;
IF V2005 GE 9 THEN V2005=.;
IF V2006 GE 9 THEN V2006=.;
IF V2007 GE 999 THEN V2007=.;
IF V2008 GE 99 THEN V2008=.;
IF V2009 GE 99 THEN V2009=.;
IF V2010 GE 9 THEN V2010=.;
IF V2011 GE 9 THEN V2011=.;
IF V2012 GE 9 THEN V2012=.;
IF V2013 GE 9 THEN V2013=.;
IF V2014 GE 99 THEN V2014=.;
IF V2015 GE 9 THEN V2015=.;
IF V2016 GE 9 THEN V2016=.;
IF V2017 GE 9 THEN V2017=.;
IF V2018 GE 9 THEN V2018=.;
IF V2019 GE 9 THEN V2019=.;
IF V2020 GE 9 THEN V2020=.;
IF V2021 GE 9 THEN V2021=.;
IF V2022 GE 999 THEN V2022=.;
IF V2023 GE 9 THEN V2023=.;
IF V2024 GE 9 THEN V2024=.;
IF V2025 GE 9 THEN V2025=.;
IF V2026 GE 9 THEN V2026=.;
IF V2027 GE 999 THEN V2027=.;
IF V2028 GE 9 THEN V2028=.;
IF V2029 GE 9 THEN V2029=.;
IF V2030 GE 9 THEN V2030=.;
IF V2031 GE 9 THEN V2031=.;
IF V2032 GE 999 THEN V2032=.;
IF V2033 GE 9 THEN V2033=.;
IF V2034 GE 9 THEN V2034=.;
IF V2035 GE 9 THEN V2035=.;
IF V2036 GE 9 THEN V2036=.;
IF V2038 GE 9 THEN V2038=.;
IF V2039 GE 99 THEN V2039=.;
IF V2040 GE 99 THEN V2040=.;
IF V2041 GE 99 THEN V2041=.;
IF V2042 GE 99 THEN V2042=.;
IF V2043 GE 99 THEN V2043=.;
IF V2044 GE 9 THEN V2044=.;
IF V2045 GE 9 THEN V2045=.;
IF V2046 GE 9 THEN V2046=.;
IF V2047 GE 9 THEN V2047=.;
IF V2048 GE 9 THEN V2048=.;
IF V2049 GE 9 THEN V2049=.;
IF V2050 GE 999 THEN V2050=.;
IF V2051 GE 9 THEN V2051=.;
IF V2052 GE 999 THEN V2052=.;
IF V2053 GE 9 THEN V2053=.;
IF V2054 GE 9 THEN V2054=.;
IF V2055 GE 9 THEN V2055=.;
IF V2056 GE 9 THEN V2056=.;
IF V2057 GE 9 THEN V2057=.;
IF V2060 GE 99 THEN V2060=.;
IF V2061 GE 99 THEN V2061=.;
IF V2062 GE 9 THEN V2062=.;
IF V2063 GE 9 THEN V2063=.;
IF V2064 GE 999 THEN V2064=.;
IF V2065 GE 9 THEN V2065=.;
IF V2066 GE 9 THEN V2066=.;
IF V2067 GE 9 THEN V2067=.;
IF V2068 GE 9 THEN V2068=.;
IF V2069 GE 999 THEN V2069=.;
IF V2070 GE 9 THEN V2070=.;
IF V2071 GE 9 THEN V2071=.;
IF V2073 GE 9 THEN V2073=.;
IF V2076 GE 99 THEN V2076=.;
IF V2077 GE 99 THEN V2077=.;
IF V2078 GE 9 THEN V2078=.;
IF V2079 GE 9 THEN V2079=.;
IF V2080 GE 9 THEN V2080=.;
IF V2081 GE 9 THEN V2081=.;
IF V2082 GE 9 THEN V2082=.;
IF V2083 GE 9 THEN V2083=.;
IF V2084 GE 9 THEN V2084=.;
IF V2085 GE 9 THEN V2085=.;
IF V2086 GE 9 THEN V2086=.;
IF V2087 GE 9 THEN V2087=.;
IF V2088 GE 99 THEN V2088=.;
IF V2089 GE 9 THEN V2089=.;
IF V2090 GE 9 THEN V2090=.;
IF V2091 GE 9 THEN V2091=.;
IF V2092 GE 9 THEN V2092=.;
IF V2093 GE 9 THEN V2093=.;
IF V2094 GE 9 THEN V2094=.;
IF V2095 GE 9 THEN V2095=.;
IF V2096 GE 9 THEN V2096=.;
IF V2097 GE 9 THEN V2097=.;
IF V2098 GE 9 THEN V2098=.;
IF V2099 GE 9 THEN V2099=.;
IF V2100 GE 9 THEN V2100=.;
IF V2101 GE 9 THEN V2101=.;
IF V2102 GE 9 THEN V2102=.;
IF V2103 GE 9 THEN V2103=.;
IF V2104 GE 9 THEN V2104=.;
IF V2105_1 GE 9 THEN V2105_1=.;
IF V2105_2 GE 9 THEN V2105_2=.;
IF V2106 GE 9 THEN V2106=.;
IF V2107 GE 9 THEN V2107=.;
IF V2108 GE 9 THEN V2108=.;
IF V2109 GE 9 THEN V2109=.;
IF V2110_1 GE 9 THEN V2110_1=.;
IF V2110_2 GE 9 THEN V2110_2=.;
IF V2111 GE 9 THEN V2111=.;
IF V2112 GE 9 THEN V2112=.;
IF V2113 GE 9 THEN V2113=.;
IF V2114 GE 9 THEN V2114=.;
IF V2115 GE 9 THEN V2115=.;
IF V2116 GE 9 THEN V2116=.;
IF V2117 GE 9 THEN V2117=.;
IF V2118 GE 9 THEN V2118=.;
IF V2119 GE 9 THEN V2119=.;
IF V2120 GE 9 THEN V2120=.;
IF V2121 GE 9 THEN V2121=.;
IF V2122 GE 9 THEN V2122=.;
IF V2123 GE 9 THEN V2123=.;
IF V2124 GE 9 THEN V2124=.;
IF V2125 GE 9 THEN V2125=.;
IF V2126 GE 9 THEN V2126=.;
IF V2127 GE 9 THEN V2127=.;
IF V2128 GE 99 THEN V2128=.;
IF V2129 GE 9 THEN V2129=.;
IF V2130 GE 9 THEN V2130=.;
IF V2131 GE 9 THEN V2131=.;
IF V2132 GE 99 THEN V2132=.;
IF V2133 GE 9 THEN V2133=.;
IF V2134 GE 9 THEN V2134=.;
IF V2135 GE 9 THEN V2135=.;
IF V2136_1 GE 9 THEN V2136_1=.;
IF V2136_2 GE 9 THEN V2136_2=.;
IF V2137 GE 9 THEN V2137=.;
IF V2138 GE 9 THEN V2138=.;
IF V2139 GE 9 THEN V2139=.;
IF V2140 GE 9 THEN V2140=.;
IF V2141 GE 9 THEN V2141=.;
IF V2142 GE 9 THEN V2142=.;
IF V2143 GE 9 THEN V2143=.;
IF V2144 GE 9 THEN V2144=.;
IF V2145 GE 9 THEN V2145=.;
IF V2146 GE 9 THEN V2146=.;
IF V2147 GE 9 THEN V2147=.;
IF V2148 GE 9 THEN V2148=.;
IF V2149 GE 9 THEN V2149=.;
IF V2150 GE 9 THEN V2150=.;
IF V2151 GE 9 THEN V2151=.;
IF V2152 GE 9 THEN V2152=.;
IF V2153 GE 9 THEN V2153=.;
IF V2154 GE 9 THEN V2154=.;
IF V2155 GE 9 THEN V2155=.;
IF V2156 GE 9 THEN V2156=.;
IF V2157 GE 9 THEN V2157=.;
IF V2158 GE 9 THEN V2158=.;
IF V2159 GE 9 THEN V2159=.;
IF V2160 GE 9 THEN V2160=.;
IF V2161 GE 9 THEN V2161=.;
IF V2162 GE 9 THEN V2162=.;
IF V2163 GE 9 THEN V2163=.;
IF V2164 GE 9 THEN V2164=.;
IF V2165 GE 9 THEN V2165=.;
IF V2166 GE 99 THEN V2166=.;
IF V2167 GE 999 THEN V2167=.;
IF V2168 GE 99 THEN V2168=.;
IF V2169 GE 999 THEN V2169=.;
IF V2172 GE 9 THEN V2172=.;
IF V2173 GE 99 THEN V2173=.;
IF V2174 GE 99 THEN V2174=.;
IF V2175 GE 99 THEN V2175=.;
IF V2176 GE 99 THEN V2176=.;
IF V2177 GE 9 THEN V2177=.;
IF V2178 GE 9 THEN V2178=.;
IF V2179 GE 9 THEN V2179=.;
IF V2180 GE 99 THEN V2180=.;
IF V2181 GE 9 THEN V2181=.;
IF V2182 GE 9 THEN V2182=.;
IF V2183 GE 9 THEN V2183=.;
IF V2184 GE 99 THEN V2184=.;
IF V2185 GE 9 THEN V2185=.;
IF V2186 GE 9 THEN V2186=.;
IF V2188 GE 9 THEN V2188=.;
IF V2189 GE 99 THEN V2189=.;
IF V2190 GE 999 THEN V2190=.;
IF V2191 GE 9 THEN V2191=.;
IF V2192 GE 9 THEN V2192=.;
IF V2193 GE 9 THEN V2193=.;
IF V2194 GE 9 THEN V2194=.;
IF V2195 GE 9 THEN V2195=.;
IF V2196 GE 9 THEN V2196=.;
IF V2197 GE 9 THEN V2197=.;
IF V2198 GE 9 THEN V2198=.;
IF V2199 GE 9 THEN V2199=.;
IF V2200 GE 9 THEN V2200=.;
IF V2201 GE 9 THEN V2201=.;
IF V2202 GE 9 THEN V2202=.;
IF V2203 GE 9 THEN V2203=.;
IF V2204 GE 9 THEN V2204=.;
IF V2205 GE 9 THEN V2205=.;
IF V2206 GE 9 THEN V2206=.;
IF V2207 GE 9 THEN V2207=.;
IF V2208 GE 9 THEN V2208=.;
IF V2211 GE 9 THEN V2211=.;
IF V2212 GE 9 THEN V2212=.;
IF V2213 GE 9 THEN V2213=.;
IF V2214 GE 9 THEN V2214=.;
IF V2215 GE 9 THEN V2215=.;
IF V2216 GE 9 THEN V2216=.;
IF V2217 GE 9 THEN V2217=.;
IF V2218_1 GE 9 THEN V2218_1=.;
IF V2218_2 GE 9 THEN V2218_2=.;
IF V2283=9 THEN V2283=.;
IF V2284=9 THEN V2284=.;
IF V2285=9 THEN V2285=.;
IF V2286=9 THEN V2286=.;
IF V2287=9 THEN V2287=.;
IF V2288=9 THEN V2288=.;
IF V2294=99999 THEN V2294=.;
IF V2295=9 THEN V2295=.;
IF V2297=9 THEN V2297=.;
IF V2298=9 THEN V2298=.;
IF V2299=9 THEN V2299=.;
IF V2301=9.9 THEN V2301=.;
IF V2302=9 THEN V2302=.;
IF V2331 GE 9 THEN V2331=.;
IF V2332 GE 9 THEN V2332=.;
IF V2333 GE 9 THEN V2333=.;
IF V2334 GE 9 THEN V2334=.;
IF V2335 GE 9 THEN V2335=.;
IF V2336 GE 9 THEN V2336=.;
IF V2337 GE 9 THEN V2337=.;
IF V2338 GE 9 THEN V2338=.;
IF V2339 GE 999 THEN V2339=.;
IF V2340 GE 999 THEN V2340=.;
IF V2341 GE 999 THEN V2341=.;
IF V2342 GE 999 THEN V2342=.;
IF V2343 GE 9 THEN V2343=.;
IF V2344 GE 9 THEN V2344=.;
 
file rawdat lrecl=949;
put    
v1802
v1809
v1823
v1824
v1829
v1830
v1834
v1835
v1839
v1840
v1849
v1850
v1871
v1876
v1877
v1884
v1885
v1886
v1887
v1897
v1898
v1899
v1900
v1904
v1905
v1906
v1910
v1922
v1923
v1924
v1926
v1927
v1939
v1941
v1942
v1943
v1944
v1957
v1967
v1968
v1979
v1980
v1983
v1986
v1988
v1998
v1999
v2038
v2039
v2040
v2072
v2076
v2077
v2097
v2112
v2121
v2165
v2197
v2202
v2226
v2284
v2289
v2321
v30071
;

 proc means;
 run; 
